/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.util;

import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class SearchTools {
    public static Item findItem(String registryNameString) {
        if (registryNameString == null || !registryNameString.contains(":")) {
            return Items.f_41852_;
        }
        ResourceLocation location = new ResourceLocation(registryNameString);
        Item result = (Item)ForgeRegistries.ITEMS.getValue(location);
        if (result == null) {
            return Items.f_41852_;
        }
        return result;
    }

    public static Item[] findItemList(String[] itemList) {
        if (itemList == null || itemList.length == 0) {
            return new Item[0];
        }
        return (Item[])Arrays.stream(itemList).map(SearchTools::getItemFromRegistry).toArray(Item[]::new);
    }

    private static Item getItemFromRegistry(String registryNameString) {
        if (registryNameString == null || !registryNameString.contains(":")) {
            return Items.f_41852_;
        }
        ResourceLocation location = new ResourceLocation(registryNameString);
        Item result = (Item)ForgeRegistries.ITEMS.getValue(location);
        return result != null ? result : Items.f_41852_;
    }
}

